<?php
// upload_comprovante.php
session_start();
include_once 'config.php';

// Segurança: Garante que só usuários com sessão ativa (ou recém-cadastrados com ID no POST) podem enviar
$user_id = $_POST['user_id'] ?? $_SESSION['user_id'] ?? null;
$amount = $_POST['valor'] ?? '97.00'; 

if (!$user_id) {
    header("Location: login.html?error=" . urlencode("Sua sessão expirou. Faça login novamente."));
    exit;
}

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_FILES["comprovante"])) {
    
    $target_dir = "uploads/comprovantes/"; // Pasta onde os arquivos serão salvos
    
    // Certifique-se de que a pasta existe e tem permissão de escrita!
    if (!is_dir($target_dir)) {
        mkdir($target_dir, 0777, true); 
    }

    $file_extension = pathinfo($_FILES["comprovante"]["name"], PATHINFO_EXTENSION);
    $new_file_name = "pix_user_{$user_id}_" . time() . "." . $file_extension;
    $target_file = $target_dir . $new_file_name;
    
    $uploadOk = 1;
    $fileType = strtolower($file_extension);
    
    // 1. Verificar tipo de arquivo (JPEG, PNG, PDF)
    if ($fileType != "jpg" && $fileType != "png" && $fileType != "jpeg" && $fileType != "pdf") {
        $error_message = "Apenas arquivos JPG, JPEG, PNG e PDF são permitidos.";
        $uploadOk = 0;
    }

    // 2. Tentar mover o arquivo para o destino
    if ($uploadOk == 1) {
        if (move_uploaded_file($_FILES["comprovante"]["tmp_name"], $target_file)) {
            
            // Sucesso no Upload: Registrar no Banco de Dados
            try {
                $status = 'pendente';
                $comprovante_url = $target_file; 
                
                $stmt = $conn->prepare("INSERT INTO payments (user_id, valor, comprovante_url, status) VALUES (?, ?, ?, ?)");
                $stmt->bind_param("idss", $user_id, $amount, $comprovante_url, $status);
                $stmt->execute();
                
                // Redireciona com mensagem de sucesso
                header("Location: payment_page.php?upload_success=1");
                exit;

            } catch (Exception $e) {
                // Se falhar a inserção, remove o arquivo
                unlink($target_file); 
                $error_message = "Erro ao registrar no banco de dados. Tente novamente.";
            }
            
        } else {
            $error_message = "Erro ao mover o arquivo. Verifique as permissões da pasta 'uploads'.";
        }
    }
    
    // Se houve erro, redireciona para a página de pagamento com a mensagem de erro
    header("Location: payment_page.php?upload_error=" . urlencode($error_message));
    exit;

} else {
    header("Location: payment_page.php");
    exit;
}
?>