// sw.js (Service Worker)

const CACHE_NAME = 'energia-fitne-cache-v1';
const urlsToCache = [
    '/',
    '/index.html',
    '/login.html',
    '/css/style.css',
    '/js/timer.js',
    // Adicione outros arquivos estáticos críticos, como fontes e imagens
];

// Instalação: Armazena arquivos no cache
self.addEventListener('install', event => {
    event.waitUntil(
        caches.open(CACHE_NAME)
            .then(cache => {
                console.log('Opened cache');
                return cache.addAll(urlsToCache);
            })
    );
});

// Busca: Serve os arquivos do cache quando possível
self.addEventListener('fetch', event => {
    event.respondWith(
        caches.match(event.request)
            .then(response => {
                // Cache hit - retorna a resposta armazenada
                if (response) {
                    return response;
                }
                // Nenhum cache encontrado - busca na rede
                return fetch(event.request);
            })
    );
});