<?php
// register.php
include_once 'config.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    
    // 1. Limpeza e sanitização de dados
    $nome = trim($_POST['nome']);
    $email = trim($_POST['email']);
    $senha = $_POST['senha']; 
    $ref_code = $_POST['ref_id'] ?? null; // Pega o código do indicador (pode ser nulo)

    // 2. Criptografia da senha (ESSENCIAL para segurança)
    $senha_hash = password_hash($senha, PASSWORD_DEFAULT);
    
    // 3. Gerar código de referência único para o novo usuário
    $link_ref = md5(uniqid(rand(), true)); 

    $id_indicador = null;

    // 4. Se houver um código de indicador, precisamos encontrar o ID no banco
    if ($ref_code) {
        $stmt_ref = $conn->prepare("SELECT id FROM users WHERE link_ref = ?");
        $stmt_ref->bind_param("s", $ref_code);
        $stmt_ref->execute();
        $result_ref = $stmt_ref->get_result();
        
        if ($result_ref->num_rows > 0) {
            $id_indicador = $result_ref->fetch_assoc()['id'];
        }
    }

    // 5. Inserir o novo usuário no banco de dados
    try {
        // Status inicial: 'pendente' (aguardando PIX)
        $status = 'pendente'; 
        
        $stmt = $conn->prepare("INSERT INTO users (nome, email, senha_hash, status, id_indicador, link_ref) VALUES (?, ?, ?, ?, ?, ?)");
        $stmt->bind_param("ssssis", $nome, $email, $senha_hash, $status, $id_indicador, $link_ref);
        
        if ($stmt->execute()) {
            // Sucesso no registro: Redirecionar para a página de Pagamento
            header("Location: payment_page.php?success=1");
            exit;
        } else {
            // Erro na execução
            throw new Exception("Erro ao registrar o usuário.");
        }
    } catch (Exception $e) {
        // Gerenciamento de erro de email duplicado
        if ($conn->errno == 1062) {
             $error_message = "Este e-mail já está cadastrado. Tente fazer login.";
        } else {
             $error_message = "Ocorreu um erro no registro: " . $e->getMessage();
        }
        // Redirecionar para a página inicial com mensagem de erro (você deve exibir isso no HTML)
        header("Location: index.html?error=" . urlencode($error_message));
        exit;
    }
    
} else {
    // Acesso direto ao arquivo PHP sem POST
    header("Location: index.html");
    exit;
}
?>