<?php
// payment_page.php (ATUALIZADO)
session_start();
include_once 'config.php';

// ... (Mantenha os redirecionamentos de segurança e busca de status) ...

// 1. CARREGA CONFIGURAÇÕES GLOBAIS
$settings = [];
$result_settings = $conn->query("SELECT setting_key, setting_value FROM settings WHERE setting_key = 'plano_mensal_valor'");
if ($result_settings) {
    while ($row = $result_settings->fetch_assoc()) {
        $settings[$row['setting_key']] = $row['setting_value'];
    }
}
$AMOUNT = $settings['plano_mensal_valor'] ?? "30.00"; // Pega o novo preço

// ... (Mantenha o restante da lógica de busca de pagamento e mensagens de feedback) ...

// Mensagens de feedback
$message = '';
if (isset($_GET['upload_success']) && $_GET['upload_success'] == 1) {
    $message = '<div class="alert success">✅ Comprovante enviado com sucesso! Sua conta será ativada em até 2 horas úteis.</div>';
    $payment_status = 'upload_waiting'; // Novo status visual
} elseif (isset($_GET['upload_error'])) {
    $message = '<div class="alert error">❌ Erro ao enviar comprovante: ' . htmlspecialchars($_GET['upload_error']) . '</div>';
}

// Dados do PIX (Você deve configurar isso no painel Admin idealmente)
$PIX_KEY = "123.456.789-00"; // Chave PIX de exemplo
$PIX_NAME = "ENERGIA FITNE LTDA";
// $AMOUNT já está definido acima

?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Status de Pagamento - Energia Fitne</title>
    <link rel="stylesheet" href="css/style.css"> 
    <style>
        .alert { padding: 15px; margin-bottom: 20px; border-radius: 4px; font-weight: bold; }
        .success { background-color: #e8f5e9; color: #388e3c; border: 1px solid #388e3c; }
        .error { background-color: #ffebee; color: #c62828; border: 1px solid #c62828; }
        .pix-info { background: #fff3e0; padding: 20px; border-radius: 8px; margin-bottom: 30px; border-left: 5px solid #ff9800; }
        .upload-box { background: white; padding: 30px; border-radius: 8px; box-shadow: 0 4px 10px rgba(0,0,0,0.1); }
    </style>
</head>
<body style="background-color: #f4f4f4;">
    <div class="container" style="max-width: 600px; padding: 50px 0;">
        <h1 style="text-align: center; color: #f44336;">Área de Ativação de Conta</h1>
        
        <?php echo $message; ?>

        <?php if ($payment_status === 'upload_waiting'): ?>
            <div class="alert success">
                Obrigado! Seu comprovante está em análise. Fique de olho no seu e-mail.
            </div>
            <p style="text-align: center;"><a href="logout.php">Sair</a></p>

        <?php elseif ($payment_status === 'pendente' || $user_id === null): ?>
            <div class="pix-info">
                <h3>Passo 1: Faça o Pagamento via PIX</h3>
                <p><strong>Valor:</strong> R$ <?php echo number_format((float)$AMOUNT, 2, ',', '.'); ?> (Plano de Lançamento)</p>
                <p><strong>Chave PIX (CPF/CNPJ):</strong> <?php echo $PIX_KEY; ?></p>
                <p><strong>Nome:</strong> <?php echo $PIX_NAME; ?></p>
                <p style="font-style: italic;">Sua conta será ativada e seu link de indicação gerado somente após a confirmação do pagamento pelo Admin.</p>
            </div>

            <div class="upload-box">
                <h3>Passo 2: Envie o Comprovante</h3>
                
                <form action="upload_comprovante.php" method="POST" enctype="multipart/form-data">
                    <input type="hidden" name="user_id" value="<?php echo htmlspecialchars($user_id); ?>">
                    <input type="hidden" name="valor" value="<?php echo $AMOUNT; ?>">
                    
                    <label for="comprovante" style="display: block; margin-bottom: 10px;">Selecione a Imagem do Comprovante (JPG, PNG ou PDF):</label>
                    <input type="file" name="comprovante" id="comprovante" accept=".jpg,.jpeg,.png,.pdf" required style="width: 100%; padding: 10px; margin-bottom: 15px;">
                    
                    <button type="submit" class="cta-button primary-button" style="width: 100%;">ENVIAR COMPROVANTE PARA ANÁLISE</button>
                </form>
            </div>
        
        <?php else: ?>
            <div class="alert success">
                Sua conta está **ATIVA**! Se você chegou aqui por engano, faça login novamente.
            </div>
            <p style="text-align: center;"><a href="login.html">Ir para o Login</a></p>

        <?php endif; ?>
    </div>
</body>
</html>