<?php
// login.php (CÓDIGO REVISADO)
session_start();
include_once 'config.php';

$error = '';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $email = trim($_POST['email']);
    $senha = $_POST['senha'];

    // 1. Validar se os campos estão preenchidos
    if (empty($email) || empty($senha)) {
        $error = "Por favor, preencha todos os campos.";
    } else {
        // 2. Buscar usuário no banco de dados
        $stmt = $conn->prepare("SELECT id, nome, senha_hash, status FROM users WHERE email = ?");
        $stmt->bind_param("s", $email);
        $stmt->execute();
        $result = $stmt->get_result();
        
        if ($result->num_rows === 1) {
            $user = $result->fetch_assoc();
            
            // 3. Verificar a senha
            if (password_verify($senha, $user['senha_hash'])) {
                
                // Senha correta: Iniciar Sessão
                $_SESSION['logged_in'] = true;
                $_SESSION['user_id'] = $user['id'];
                $_SESSION['user_nome'] = $user['nome'];
                $_SESSION['user_status'] = $user['status'];
                $_SESSION['user_email'] = $user['email'];

                // 4. Redirecionamento baseado no STATUS e TIPO
                
                if ($user['status'] === 'admin') {
                    // Redireciona para o painel de ADMIN
                    header("Location: admin/dashboard.php");
                    exit;
                    
                } elseif ($user['status'] === 'ativo') {
                    // Redireciona para o painel do CLIENTE ATIVO
                    header("Location: client/dashboard.php");
                    exit;
                    
                } elseif ($user['status'] === 'pendente') {
                    // Redireciona para a página de PAGAMENTO/ATIVAÇÃO
                    header("Location: payment_page.php");
                    exit;
                    
                } else {
                    // Status desconhecido, volta para o login com erro
                    $error = "Seu status de conta é desconhecido. Contate o suporte.";
                }

            } else {
                // Senha incorreta
                $error = "Credenciais inválidas. Verifique seu e-mail e senha.";
            }
        } else {
            // E-mail não encontrado
            $error = "Credenciais inválidas. Verifique seu e-mail e senha.";
        }
    }
}

// Se houver erro, exibe o formulário de login com a mensagem de erro
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Login - Energia Fitne</title>
    <link rel="stylesheet" href="css/style.css">
</head>
<body style="background-color: #f7f7f7;">
    <header>
        <div class="container">
            <div class="logo">ENERGIA FITNE</div>
            <nav>
                <ul>
                    <li><a href="index.html">Home</a></li>
                    <li><a href="register.php">Cadastre-se</a></li>
                </ul>
            </nav>
        </div>
    </header>

    <section id="login-form" class="padded-section" style="min-height: 80vh;">
        <div class="container">
            <div class="registration-form">
                <h2 class="section-title">Acesse Sua Área</h2>

                <?php if ($error): ?>
                    <div style="padding: 15px; margin-bottom: 20px; border-radius: 4px; background-color: #ffebee; color: #c62828; border: 1px solid #c62828;">
                        <?php echo $error; ?>
                    </div>
                <?php endif; ?>

                <form action="login.php" method="POST">
                    <input type="email" id="email" name="email" placeholder="Seu E-mail de Cadastro" required>
                    <input type="password" id="senha" name="senha" placeholder="Sua Senha" required>
                    
                    <button type="submit" class="cta-button primary-button" style="width: 100%; margin-top: 10px;">Entrar</button>
                    <p style="text-align: center; margin-top: 20px;"><a href="register.php">Ainda não tem conta? Cadastre-se aqui.</a></p>
                </form>
            </div>
        </div>
    </section>

    <footer>
        <div class="container">
            <p>&copy; 2025 Energia Fitne. Todos os direitos reservados.</p>
        </div>
    </footer>
</body>
</html>