// js/timer.js
document.addEventListener('DOMContentLoaded', () => {
    // A função é global para poder ser chamada pelo onclick do HTML
    window.startTimer = function(displayId, duration) {
        let timer = duration, minutes, seconds;
        const display = document.getElementById(displayId);
        const audio = document.getElementById('timer-sound'); 
    
        if (!display) {
            console.error("Elemento de display do cronômetro não encontrado.");
            return;
        }
    
        // Encontra o botão (elemento seguinte ao H4)
        const button = display.nextElementSibling;
        if (button) {
            button.disabled = true;
            button.textContent = 'Descansando...';
        }
    
        const interval = setInterval(function () {
            minutes = parseInt(timer / 60, 10);
            seconds = parseInt(timer % 60, 10);
    
            minutes = minutes < 10 ? "0" + minutes : minutes;
            seconds = seconds < 10 ? "0" + seconds : seconds;
    
            display.textContent = minutes + ":" + seconds;
    
            if (--timer < 0) {
                clearInterval(interval);
                
                display.textContent = "PRÓXIMO!";
                
                // Toca a música MP3
                if (audio) {
                    audio.play();
                }
    
                // Restaura o botão e permite reiniciar o descanso
                if (button) {
                    button.disabled = false;
                    button.textContent = 'INICIAR NOVO DESCANSO';
                    // Nota: O HTML deve ter um novo botão para o próximo exercício ou a lógica deve ser ajustada.
                }
            }
        }, 1000);
    }
});