// js/referral_check.js
document.addEventListener('DOMContentLoaded', function() {
    // 1. Pega os parâmetros da URL
    const urlParams = new URLSearchParams(window.location.search);
    
    // 2. Procura pelo parâmetro 'ref' (link de indicação)
    const referrerCode = urlParams.get('ref');
    
    // 3. Se um código for encontrado, preenche o campo oculto
    if (referrerCode) {
        const refIdField = document.getElementById('ref_id');
        if (refIdField) {
            // O valor do campo oculto será o código do indicador
            refIdField.value = referrerCode;
            console.log("Indicador rastreado:", referrerCode);
        }
    }
});