<?php
// functions/mlm_logic.php (FUNÇÃO ATUALIZADA)

// ... (MANTENHA A FUNÇÃO calculate_mlm_commissions ACIMA) ...

/**
 * Ativa o usuário, registra o pagamento e dispara o cálculo do MLM.
 * (Função chamada pela Área ADMIN após validação do PIX)
 * @param int $user_id ID do cliente a ser ativado
 * @param float $amount Valor da mensalidade paga
 * @param int $payment_id ID do pagamento específico a ser aprovado (NOVO PARÂMETRO)
 */
function activate_user_and_trigger_mlm($user_id, $amount, $payment_id) {
    global $conn;
    
    // 1. Mudar o status do usuário para ATIVO
    $stmt_user = $conn->prepare("UPDATE users SET status = 'ativo' WHERE id = ?");
    $stmt_user->bind_param("i", $user_id);
    $stmt_user->execute();

    // 2. Registrar o pagamento como APROVADO
    // Usamos o payment_id para garantir que estamos aprovando o PIX correto
    $stmt_payment = $conn->prepare("UPDATE payments SET status = 'aprovado' WHERE id = ? AND user_id = ?");
    $stmt_payment->bind_param("ii", $payment_id, $user_id);
    $stmt_payment->execute();
    
    if ($stmt_payment->affected_rows === 0) {
        // Falha ao aprovar o pagamento (pode ter sido aprovado duas vezes ou valor incorreto)
        return false; 
    }

    // 3. Disparar a regra de comissionamento
    calculate_mlm_commissions($user_id, $amount);
    
    return true;
}
?>