<?php
// PHP ESTRUTURAL (PRECISA DE CONEXÃO COM O BANCO DE DADOS)

/**
 * Função para calcular as comissões em 5 níveis
 * @param int $pagador_id ID do cliente que acabou de pagar a mensalidade
 * @param float $valor_mensalidade Valor base da mensalidade
 */
function calculate_mlm_commissions($pagador_id, $valor_mensalidade) {
    // Definir as porcentagens de comissão por nível (Exemplo)
    $commission_rates = [
        1 => 0.20, // 20% para o Nível 1
        2 => 0.05, // 5% para o Nível 2
        3 => 0.03, // 3% para o Nível 3
        4 => 0.02, // 2% para o Nível 4
        5 => 0.01  // 1% para o Nível 5
    ];

    $current_user_id = $pagador_id;
    
    // Loop para percorrer até 5 níveis de profundidade
    for ($level = 1; $level <= 5; $level++) {
        
        // 1. BUSCAR O INDICADOR DO USUÁRIO ATUAL (PHP & SQL)
        // PSEUDOCÓDIGO SQL: SELECT id_indicador FROM users WHERE id = $current_user_id;
        $result = run_query("SELECT id_indicador FROM users WHERE id = ?", [$current_user_id]);
        $indicator = $result->fetch_assoc();
        
        $indicator_id = $indicator['id_indicador'];

        // Se não houver mais indicador ou for NULL, a cadeia parou
        if (!$indicator_id) {
            break; 
        }

        // 2. CALCULAR O VALOR DA COMISSÃO
        $rate = $commission_rates[$level];
        $commission_amount = $valor_mensalidade * $rate;

        // 3. REGISTRAR A COMISSÃO NO BANCO DE DADOS (PHP & SQL)
        // PSEUDOCÓDIGO SQL: INSERT INTO commissions (user_id_ganhador, user_id_pagador, nivel, valor, status_pagamento) 
        //                    VALUES ($indicator_id, $pagador_id, $level, $commission_amount, 'a pagar');
        run_query("INSERT INTO commissions ...", [...]);
        
        // 4. Mover para o próximo nível (o indicador atual se torna o usuário para o próximo loop)
        $current_user_id = $indicator_id;
    }
}

// -------------------------------------------------------------------------------------------------

/**
 * Lógica para ATIVAR O USUÁRIO (A ser chamada pela Área Admin após aprovação do PIX)
 * @param int $user_id ID do cliente a ser ativado
 * @param float $amount Valor pago (para fins de auditoria)
 */
function activate_user_and_trigger_mlm($user_id, $amount) {
    // 1. Mudar o status do usuário para ATIVO
    // PSEUDOCÓDIGO SQL: UPDATE users SET status = 'ativo' WHERE id = $user_id;

    // 2. Registrar o pagamento como APROVADO
    // PSEUDOCÓDIGO SQL: UPDATE payments SET status = 'aprovado' WHERE user_id = $user_id AND status = 'pendente';

    // 3. Disparar a regra de comissionamento
    calculate_mlm_commissions($user_id, $amount);
}