<?php
// client/withdrawal.php (ATUALIZADO para coleta de PIX)
include 'security_check.php';
include_once '../config.php';

$user_id = $_SESSION['user_id'];

// 0. BUSCA DADOS DO USUÁRIO, INCLUINDO CHAVE PIX
$stmt_user = $conn->prepare("SELECT pix_key, pix_key_type FROM users WHERE id = ?");
$stmt_user->bind_param("i", $user_id);
$stmt_user->execute();
$user_data = $stmt_user->get_result()->fetch_assoc();
$client_pix_key = $user_data['pix_key'];
$client_pix_key_type = $user_data['pix_key_type'];
$PIX_REQUIRED = true; // Força o cadastro da chave

// 0.1. PROCESSA REGISTRO/ATUALIZAÇÃO DA CHAVE PIX
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['update_pix_key'])) {
    $new_pix_key = trim($_POST['new_pix_key']);
    $new_pix_key_type = 'cpf'; // Forçamos o CPF conforme o requisito

    // Validação básica de CPF (somente para formato, não para validade real)
    if ($new_pix_key == '') {
         $error = "A chave PIX (CPF) não pode ser vazia.";
    } elseif ($new_pix_key_type != 'cpf') {
        $error = "Apenas chaves PIX do tipo CPF são permitidas.";
    } else {
        $stmt_update = $conn->prepare("UPDATE users SET pix_key = ?, pix_key_type = ? WHERE id = ?");
        $stmt_update->bind_param("ssi", $new_pix_key, $new_pix_key_type, $user_id);
        
        if ($stmt_update->execute()) {
            $success = "Sua chave PIX (CPF) foi registrada com sucesso!";
            $client_pix_key = $new_pix_key; // Atualiza a variável para liberar o saque
        } else {
            $error = "Erro ao salvar a chave PIX. Tente novamente.";
        }
    }
}

// 1. CARREGA CONFIGURAÇÕES GLOBAIS
$settings = [];
$result_settings = $conn->query("SELECT setting_key, setting_value FROM settings");
while ($row = $result_settings->fetch_assoc()) {
    $settings[$row['setting_key']] = $row['setting_value'];
}
$MIN_SAQUE = (float)$settings['saque_minimo'];
$TAXA_PERCENTUAL = (float)$settings['saque_taxa_percentual_extra'];
$SAQUE_GRATIS_MES = (int)$settings['saque_gratis_por_mes'];

// 2. BUSCA SALDO DISPONÍVEL (A PAGAR)
$total_commission = $conn->query("SELECT SUM(valor) FROM commissions WHERE user_id_ganhador = $user_id AND status_pagamento = 'a pagar'")->fetch_row()[0] ?? 0.00;
$current_balance = round((float)$total_commission, 2);

// 3. BUSCA SAQUES JÁ REALIZADOS NO MÊS ATUAL
$start_month = date('Y-m-01 00:00:00');
$stmt_count = $conn->prepare("SELECT COUNT(id) FROM withdrawals WHERE user_id = ? AND data_pedido >= ? AND status != 'rejeitado'");
$stmt_count->bind_param("is", $user_id, $start_month);
$stmt_count->execute();
$saques_feitos_mes = $stmt_count->get_result()->fetch_row()[0];

// 4. PROCESSA O PEDIDO DE SAQUE (LÓGICA)
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['request_withdrawal']) && $client_pix_key) {
    // ... (Lógica de cálculo de saque e inserção no banco permanece a mesma) ...
    $valor_solicitado = round((float)$_POST['valor_saque'], 2);
    
    if ($valor_solicitado < $MIN_SAQUE) {
        $error = "O valor mínimo para saque é R$ " . number_format($MIN_SAQUE, 2, ',', '.');
    } elseif ($valor_solicitado > $current_balance) {
        $error = "Valor solicitado excede seu saldo disponível de R$ " . number_format($current_balance, 2, ',', '.');
    } else {
        
        // CÁLCULO DA TAXA
        $taxa_aplicada = 0.00;
        $valor_a_pagar = $valor_solicitado;

        if ($saques_feitos_mes >= $SAQUE_GRATIS_MES) {
            $taxa_aplicada = $valor_solicitado * ($TAXA_PERCENTUAL / 100);
            $valor_a_pagar = $valor_solicitado - $taxa_aplicada;
        }

        // REGISTRA O PEDIDO NO BANCO
        $stmt_insert = $conn->prepare("INSERT INTO withdrawals (user_id, valor_solicitado, taxa_aplicada, valor_a_pagar, status) VALUES (?, ?, ?, ?, 'pendente')");
        $stmt_insert->bind_param("iddd", $user_id, $valor_solicitado, $taxa_aplicada, $valor_a_pagar);
        
        if ($stmt_insert->execute()) {
            $success = "Pedido de saque de R$ " . number_format($valor_a_pagar, 2, ',', '.') . " enviado! Acompanhe o status abaixo.";
            $saques_feitos_mes++; 
        } else {
            $error = "Erro ao processar o pedido. Tente novamente.";
        }
    }
}

// 5. BUSCA HISTÓRICO DE SAQUES DO CLIENTE
$withdrawals_history = [];
$result_history = $conn->query("SELECT id, valor_solicitado, taxa_aplicada, valor_a_pagar, status, data_pedido FROM withdrawals WHERE user_id = $user_id ORDER BY data_pedido DESC");
while ($row = $result_history->fetch_assoc()) {
    $withdrawals_history[] = $row;
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Pedido de Saque - Energia Fitne</title>
    <link rel="stylesheet" href="../css/style.css"> 
    <style>
        .withdrawal-form-box { max-width: 500px; margin: 30px auto; padding: 30px; background: white; border-radius: 8px; box-shadow: 0 0 15px rgba(0,0,0,0.1); }
        .alert-w { padding: 10px; margin-bottom: 15px; border-radius: 4px; }
        .alert-w.error { background-color: #ffebee; color: #c62828; border: 1px solid #c62828; }
        .alert-w.success { background-color: #e8f5e9; color: #388e3c; border: 1px solid #388e3c; }
        .pix-box { background: #e3f2fd; padding: 20px; border-radius: 8px; border-left: 5px solid #1a73e8; margin-bottom: 30px;}
    </style>
</head>
<body>
    <section id="withdrawal-area" class="padded-section">
        <div class="container">
            <h2>💰 Solicitar Saque de Comissões</h2>
            
            <?php if (isset($error)): ?><div class="alert-w error"><?php echo $error; ?></div><?php endif; ?>
            <?php if (isset($success)): ?><div class="alert-w success"><?php echo $success; ?></div><?php endif; ?>

            <div class="pix-box">
                <h3>Sua Chave PIX para Recebimento (OBRIGATÓRIO)</h3>
                <?php if ($client_pix_key): ?>
                    <p>Chave cadastrada (**<?php echo strtoupper($client_pix_key_type); ?>**): <strong><?php echo htmlspecialchars($client_pix_key); ?></strong></p>
                    <p style="color: #4caf50;">Você pode solicitar o saque abaixo.</p>
                <?php else: ?>
                    <p style="color: #f44336; font-weight: bold;">🚨 Você precisa cadastrar sua chave PIX (CPF) antes de pedir o saque.</p>
                <?php endif; ?>

                <form method="POST" style="margin-top: 15px;">
                    <label for="new_pix_key" style="display: block;">Chave PIX (Apenas CPF, digite sem pontos ou traços):</label>
                    <input type="text" id="new_pix_key" name="new_pix_key" value="<?php echo htmlspecialchars($client_pix_key ?? ''); ?>" required style="width: 100%; padding: 10px; margin-bottom: 10px;">
                    
                    <button type="submit" name="update_pix_key" class="cta-button secondary-cta" style="padding: 8px 15px;">Salvar Chave PIX</button>
                </form>
            </div>
            
            <h3 style="margin-top: 40px;">Solicitar Saque</h3>

            <div class="stats-grid" style="justify-content: flex-start;">
                </div>

            <div class="withdrawal-form-box">
                <?php if (!$client_pix_key): ?>
                    <div class="alert-w error">Cadastre sua chave PIX acima para liberar o formulário de saque.</div>
                <?php elseif ($current_balance >= $MIN_SAQUE): ?>
                    <p>Mínimo para saque: **R$ <?php echo number_format($MIN_SAQUE, 2, ',', '.'); ?>**</p>
                    <p>Taxa para saques adicionais (após o <?php echo $SAQUE_GRATIS_MES; ?>º): **<?php echo $TAXA_PERCENTUAL; ?>%**</p>
                    
                    <form method="POST">
                        <label for="valor_saque">Valor que deseja sacar (máx: R$ <?php echo number_format($current_balance, 2, ',', '.'); ?>):</label>
                        <input type="number" id="valor_saque" name="valor_saque" step="0.01" min="<?php echo $MIN_SAQUE; ?>" max="<?php echo $current_balance; ?>" required style="margin-top: 5px; margin-bottom: 20px;">
                        
                        <button type="submit" name="request_withdrawal" class="cta-button primary-button" style="width: 100%;">PEDIR SAQUE AGORA</button>
                    </form>
                <?php else: ?>
                    <div class="alert-w error">
                        Saldo insuficiente. Você precisa de no mínimo R$ <?php echo number_format($MIN_SAQUE, 2, ',', '.'); ?> para solicitar um saque.
                    </div>
                <?php endif; ?>
            </div>

            <h3 style="margin-top: 40px; color: #1a73e8;">Histórico e Status de Saques</h3>
            </div>
    </section>
</body>
</html>