<?php
// payment_page.php (ATUALIZADO para PIX Dinâmico)
session_start();
include_once 'config.php';

// Redireciona usuários ativos ou admins para o painel
if (isset($_SESSION['user_status']) && $_SESSION['user_status'] === 'ativo') {
    header("Location: client/dashboard.php");
    exit;
}
if (isset($_SESSION['user_status']) && $_SESSION['user_status'] === 'admin') {
    header("Location: admin/dashboard.php");
    exit;
}

$user_id = $_SESSION['user_id'] ?? null;
$payment_status = 'pendente'; 
if ($user_id) {
    $stmt = $conn->prepare("SELECT status FROM payments WHERE user_id = ? ORDER BY data_pagamento DESC LIMIT 1");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $result = $stmt->get_result();
    if ($result->num_rows > 0) {
        $payment_status = $result->fetch_assoc()['status'];
    }
}

// 1. CARREGA CONFIGURAÇÕES GLOBAIS (VALOR E PIX ADMIN)
$settings = [];
$result_settings = $conn->query("SELECT setting_key, setting_value FROM settings WHERE setting_key IN ('plano_mensal_valor', 'admin_pix_key', 'admin_pix_name')");
if ($result_settings) {
    while ($row = $result_settings->fetch_assoc()) {
        $settings[$row['setting_key']] = $row['setting_value'];
    }
}
$AMOUNT = $settings['plano_mensal_valor'] ?? "30.00"; 
$PIX_KEY = $settings['admin_pix_key'] ?? "PIX_NAO_CONFIGURADO"; // Agora é dinâmico!
$PIX_NAME = $settings['admin_pix_name'] ?? "ADMINISTRADOR"; // Agora é dinâmico!

// Mensagens de feedback
$message = '';
if (isset($_GET['upload_success']) && $_GET['upload_success'] == 1) {
    $message = '<div class="alert success">✅ Comprovante enviado com sucesso! Sua conta será ativada em até 2 horas úteis.</div>';
    $payment_status = 'upload_waiting'; 
} elseif (isset($_GET['upload_error'])) {
    $message = '<div class="alert error">❌ Erro ao enviar comprovante: ' . htmlspecialchars($_GET['upload_error']) . '</div>';
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Status de Pagamento - Energia Fitne</title>
    <link rel="stylesheet" href="css/style.css"> 
    <style>
        .alert { padding: 15px; margin-bottom: 20px; border-radius: 4px; font-weight: bold; }
        .success { background-color: #e8f5e9; color: #388e3c; border: 1px solid #388e3c; }
        .error { background-color: #ffebee; color: #c62828; border: 1px solid #c62828; }
        .pix-info { background: #fff3e0; padding: 20px; border-radius: 8px; margin-bottom: 30px; border-left: 5px solid #ff9800; }
        .upload-box { background: white; padding: 30px; border-radius: 8px; box-shadow: 0 4px 10px rgba(0,0,0,0.1); }
    </style>
</head>
<body style="background-color: #f4f4f4;">
    <div class="container" style="max-width: 600px; padding: 50px 0;">
        <h1 style="text-align: center; color: #f44336;">Área de Ativação de Conta</h1>
        
        <?php echo $message; ?>

        <?php if ($payment_status === 'upload_waiting'): ?>
            <?php elseif ($payment_status === 'pendente' || $user_id === null): ?>
            <div class="pix-info">
                <h3>Passo 1: Faça o Pagamento via PIX</h3>
                <p><strong>Valor:</strong> R$ <?php echo number_format((float)$AMOUNT, 2, ',', '.'); ?> (Plano de Lançamento)</p>
                <p><strong>Chave PIX:</strong> **<?php echo htmlspecialchars($PIX_KEY); ?>**</p>
                <p><strong>Nome do Recebedor:</strong> **<?php echo htmlspecialchars($PIX_NAME); ?>**</p>
                <p style="font-style: italic;">Sua conta será ativada e seu link de indicação gerado somente após a confirmação do pagamento pelo Admin.</p>
            </div>

            <div class="upload-box">
                <h3>Passo 2: Envie o Comprovante</h3>
                
                <form action="upload_comprovante.php" method="POST" enctype="multipart/form-data">
                    <input type="hidden" name="user_id" value="<?php echo htmlspecialchars($user_id); ?>">
                    <input type="hidden" name="valor" value="<?php echo $AMOUNT; ?>">
                    
                    <label for="comprovante" style="display: block; margin-bottom: 10px;">Selecione a Imagem do Comprovante (JPG, PNG ou PDF):</label>
                    <input type="file" name="comprovante" id="comprovante" accept=".jpg,.jpeg,.png,.pdf" required style="width: 100%; padding: 10px; margin-bottom: 15px;">
                    
                    <button type="submit" class="cta-button primary-button" style="width: 100%;">ENVIAR COMPROVANTE PARA ANÁLISE</button>
                </form>
            </div>
        
        <?php else: ?>
            <?php endif; ?>
    </div>
</body>
</html>