<?php
// admin/withdrawals_management.php
include 'security_check.php';
include_once '../config.php';

// AÇÃO: Mudar o status do pedido
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['withdrawal_id']) && isset($_POST['new_status'])) {
    $id = (int)$_POST['withdrawal_id'];
    $status = $_POST['new_status'];
    $data_processamento = ($status == 'pago') ? date('Y-m-d H:i:s') : null;

    $stmt_update = $conn->prepare("UPDATE withdrawals SET status = ?, data_processamento = ? WHERE id = ?");
    $stmt_update->bind_param("ssi", $status, $data_processamento, $id);
    $stmt_update->execute();
    $_SESSION['admin_message'] = "Status do saque #{$id} atualizado para " . strtoupper(str_replace('_', ' ', $status));
    header("Location: withdrawals_management.php");
    exit;
}

// BUSCA TODOS OS PEDIDOS DE SAQUE
$withdrawals = [];
$sql_withdrawals = "SELECT w.*, u.nome, u.email FROM withdrawals w JOIN users u ON w.user_id = u.id ORDER BY w.status DESC, w.data_pedido ASC";
$result_withdrawals = $conn->query($sql_withdrawals);
while ($row = $result_withdrawals->fetch_assoc()) {
    $withdrawals[] = $row;
}

// Mensagem do Admin (se houver)
$message = '';
if (isset($_SESSION['admin_message'])) {
    $message = $_SESSION['admin_message'];
    unset($_SESSION['admin_message']);
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Gestão de Saques - ADMIN</title>
    <link rel="stylesheet" href="../css/style.css"> 
</head>
<body>
    <header style="background-color: #f44336;"> 
        <div class="container">
            <nav>
                <h1>Admin - Gestão de Saques</h1>
                <ul>
                    <li><a href="dashboard.php">Dashboard</a></li>
                    <li><a href="withdrawals_management.php">Saques</a></li>
                    <li><a href="settings.php">Configurações</a></li>
                    <li><a href="../logout.php">Sair</a></li>
                </ul>
            </nav>
        </div>
    </header>

    <section class="padded-section">
        <div class="container">
            <h2>Gerenciamento de Pedidos de Saque</h2>
            <?php if ($message): ?><div style="padding: 15px; margin-bottom: 20px; background-color: #e8f5e9; color: #388e3c; border: 1px solid #388e3c; border-radius: 4px;"><?php echo $message; ?></div><?php endif; ?>

            <table class="data-table">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Cliente</th>
                        <th>Valor Líquido</th>
                        <th>Taxa</th>
                        <th>Status</th>
                        <th>Data Pedido</th>
                        <th>Ação</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($withdrawals as $w): ?>
                        <tr>
                            <td>#<?php echo $w['id']; ?></td>
                            <td><?php echo htmlspecialchars($w['nome']); ?><br><small><?php echo htmlspecialchars($w['email']); ?></small></td>
                            <td class="td-value">R$ <?php echo number_format($w['valor_a_pagar'], 2, ',', '.'); ?></td>
                            <td>R$ <?php echo number_format($w['taxa_aplicada'], 2, ',', '.'); ?></td>
                            <td><span style="font-weight: bold; color: 
                                <?php 
                                    if ($w['status'] == 'pago') echo 'green';
                                    elseif ($w['status'] == 'em_analise') echo 'blue';
                                    elseif ($w['status'] == 'rejeitado') echo 'red';
                                    else echo 'orange';
                                ?>;"><?php echo strtoupper(str_replace('_', ' ', $w['status'])); ?></span></td>
                            <td><?php echo date('d/m/Y H:i', strtotime($w['data_pedido'])); ?></td>
                            <td>
                                <form method="POST" style="display: flex; gap: 5px;">
                                    <input type="hidden" name="withdrawal_id" value="<?php echo $w['id']; ?>">
                                    <select name="new_status" required style="padding: 5px; border-radius: 4px;">
                                        <option value="pendente" <?php echo $w['status'] == 'pendente' ? 'selected' : ''; ?>>Pendente</option>
                                        <option value="em_analise" <?php echo $w['status'] == 'em_analise' ? 'selected' : ''; ?>>Em Análise</option>
                                        <option value="pago" <?php echo $w['status'] == 'pago' ? 'selected' : ''; ?>>Pago</option>
                                        <option value="rejeitado" <?php echo $w['status'] == 'rejeitado' ? 'selected' : ''; ?>>Rejeitado</option>
                                    </select>
                                    <button type="submit" class="action-button approve" style="background-color: #1a73e8; padding: 5px 10px;">Salvar</button>
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </section>
</body>
</html>