<?php
// admin/settings.php (ATUALIZADO)
include 'security_check.php';
include_once '../config.php';

// AÇÃO: Atualizar configurações
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['update_settings'])) {
    $settings_to_update = [
        'plano_mensal_valor' => $_POST['plano_mensal_valor'],
        'saque_minimo' => $_POST['saque_minimo'],
        'saque_taxa_percentual_extra' => $_POST['saque_taxa_percentual_extra'],
        'saque_gratis_por_mes' => $_POST['saque_gratis_por_mes'],
        // NOVOS CAMPOS DO PIX ADMIN
        'admin_pix_key' => $_POST['admin_pix_key'],
        'admin_pix_name' => $_POST['admin_pix_name']
    ];
    
    foreach ($settings_to_update as $key => $value) {
        $stmt = $conn->prepare("INSERT INTO settings (setting_key, setting_value) VALUES (?, ?) ON DUPLICATE KEY UPDATE setting_value = ?");
        $stmt->bind_param("sss", $key, $value, $value);
        $stmt->execute();
    }

    $_SESSION['admin_message'] = "Configurações atualizadas com sucesso!";
    header("Location: settings.php");
    exit;
}

// BUSCA TODAS AS CONFIGURAÇÕES
$settings = [];
$result_settings = $conn->query("SELECT setting_key, setting_value FROM settings");
while ($row = $result_settings->fetch_assoc()) {
    $settings[$row['setting_key']] = $row['setting_value'];
}

$message = '';
if (isset($_SESSION['admin_message'])) {
    $message = $_SESSION['admin_message'];
    unset($_SESSION['admin_message']);
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Configurações Globais - ADMIN</title>
    <link rel="stylesheet" href="../css/style.css"> 
</head>
<body>
    <header style="background-color: #f44336;"> 
        <div class="container">
            <nav>
                <h1>Admin - Configurações Globais</h1>
                <ul>
                    <li><a href="dashboard.php">Dashboard</a></li>
                    <li><a href="withdrawals_management.php">Saques</a></li>
                    <li><a href="settings.php">Configurações</a></li>
                    <li><a href="../logout.php">Sair</a></li>
                </ul>
            </nav>
        </div>
    </header>

    <section class="padded-section">
        <div class="container">
            <h2>Configurações Financeiras e de Plano</h2>
            <?php if ($message): ?><div style="padding: 15px; margin-bottom: 20px; background-color: #e8f5e9; color: #388e3c; border: 1px solid #388e3c; border-radius: 4px;"><?php echo $message; ?></div><?php endif; ?>
            
            <form method="POST" style="max-width: 600px; margin: 30px auto; padding: 30px; background: white; border-radius: 8px; box-shadow: 0 0 15px rgba(0,0,0,0.1);">
                <input type="hidden" name="update_settings" value="1">
                
                <h3 style="color: #f44336;">Plano de Assinatura</h3>
                <label for="plano_mensal_valor" style="display: block; margin-top: 15px;">Valor Mensal do Plano (R$):</label>
                <input type="number" name="plano_mensal_valor" id="plano_mensal_valor" step="0.01" value="<?php echo htmlspecialchars($settings['plano_mensal_valor'] ?? '30.00'); ?>" required style="width: 100%; padding: 10px; margin-bottom: 20px;">
                
                <h3 style="color: #1a73e8;">Regras de Saque (MLM)</h3>
                <h3 style="color: #4caf50; margin-top: 30px;">Dados de Pagamento PIX (Recebimento da Empresa)</h3>
                <p style="margin-bottom: 15px;">Estes dados aparecerão para o cliente na página de pagamento.</p>
                
                <label for="admin_pix_key" style="display: block;">Chave PIX (CPF/CNPJ/Email/Telefone):</label>
                <input type="text" name="admin_pix_key" id="admin_pix_key" value="<?php echo htmlspecialchars($settings['admin_pix_key'] ?? ''); ?>" required style="width: 100%; padding: 10px; margin-bottom: 20px;">
                
                <label for="admin_pix_name" style="display: block;">Nome do Recebedor (Empresa):</label>
                <input type="text" name="admin_pix_name" id="admin_pix_name" value="<?php echo htmlspecialchars($settings['admin_pix_name'] ?? ''); ?>" required style="width: 100%; padding: 10px; margin-bottom: 30px;">
                
                <button type="submit" class="cta-button primary-button" style="width: 100%;">SALVAR CONFIGURAÇÕES</button>
            </form>
        </div>
    </section>
</body>
</html>