-- Garanta que o banco de dados 'energia_fitne' foi criado antes de rodar este script.

-- ----------------------------
-- Tabela de Usuários (Clientes, Indicadores e Admin)
-- ----------------------------
CREATE TABLE users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    nome VARCHAR(100) NOT NULL,
    email VARCHAR(100) UNIQUE NOT NULL,
    senha_hash VARCHAR(255) NOT NULL,
    status ENUM('pendente', 'ativo', 'admin') DEFAULT 'pendente',
    
    -- Chave para o sistema MLM: ID do usuário que o indicou (NULL se não foi indicado)
    id_indicador INT NULL, 
    link_ref VARCHAR(32) UNIQUE NOT NULL, -- Código único para o link de indicação
    
    data_cadastro TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- ----------------------------
-- Tabela de Pagamentos (PIX)
-- ----------------------------
CREATE TABLE payments (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    valor DECIMAL(10, 2) NOT NULL,
    comprovante_url VARCHAR(255),
    status ENUM('pendente', 'aprovado', 'rejeitado') DEFAULT 'pendente',
    data_pagamento TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id) REFERENCES users(id)
);

-- ----------------------------
-- Tabela de Comissões (MLM - 5 Níveis)
-- ----------------------------
CREATE TABLE commissions (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id_ganhador INT NOT NULL, -- Quem vai receber a comissão
    user_id_pagador INT NOT NULL,   -- Quem fez a compra que gerou a comissão
    nivel INT NOT NULL,             -- Nível da indicação (1 a 5)
    valor DECIMAL(10, 2) NOT NULL,
    status_pagamento ENUM('a pagar', 'pago') DEFAULT 'a pagar',
    data_geracao TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id_ganhador) REFERENCES users(id)
);

-- ----------------------------
-- Tabela de Treinos (Conteúdo do Programa 5x5)
-- ----------------------------
CREATE TABLE workouts (
    id INT AUTO_INCREMENT PRIMARY KEY,
    dia_semana ENUM('segunda', 'terca', 'quarta', 'quinta', 'sexta') NOT NULL,
    exercicio_nome VARCHAR(100) NOT NULL,
    repeticoes VARCHAR(50) NOT NULL,     -- Ex: 3x10 ou 4x12
    tempo_descanso INT NOT NULL,         -- Tempo em segundos
    foto_url VARCHAR(255) NOT NULL       -- Caminho: uploads/fotos_exercicios/...
);