<?php
// admin/dashboard.php
include 'security_check.php'; // Protege a página

include_once '../config.php';

// --- 1. Lógica para buscar dados de gestão ---

// Buscar pagamentos PIX pendentes
$pending_payments = [];
$sql_pending = "SELECT 
    u.id AS user_id, 
    u.nome, 
    p.id AS payment_id, 
    p.valor, 
    p.comprovante_url,
    p.data_pagamento
FROM users u
JOIN payments p ON u.id = p.user_id
WHERE p.status = 'pendente' 
ORDER BY p.data_pagamento ASC";

$result_pending = $conn->query($sql_pending);
if ($result_pending) {
    while ($row = $result_pending->fetch_assoc()) {
        $pending_payments[] = $row;
    }
}

// Buscar estatísticas (dados para os cards)
$total_users = $conn->query("SELECT COUNT(id) FROM users")->fetch_row()[0];
$active_users = $conn->query("SELECT COUNT(id) FROM users WHERE status = 'ativo'")->fetch_row()[0];
$pending_commissions = $conn->query("SELECT SUM(valor) FROM commissions WHERE status_pagamento = 'a pagar'")->fetch_row()[0] ?? 0.00;

// Mensagem de sucesso/erro que vem do script de aprovação
$message = '';
if (isset($_SESSION['admin_message'])) {
    $message = $_SESSION['admin_message'];
    unset($_SESSION['admin_message']); // Limpa a mensagem após exibir
}

?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Área ADMIN - Gestão Energia Fitne</title>
    <link rel="stylesheet" href="../css/style.css"> 
</head>
<body>
    <header style="background-color: #f44336;"> 
        <div class="container">
            <nav>
                <h1>Admin - Gestão Central</h1>
                <ul>
                    <li><a href="dashboard.php">Dashboard</a></li>
                    <li><a href="users_management.php">Usuários</a></li>
                    <li><a href="workouts_editor.php">Gerenciar Treinos</a></li>
                    <li><a href="mlm_report.php">Relatórios MLM</a></li>
                    <li><a href="../logout.php">Sair</a></li>
                </ul>
            </nav>
        </div>
    </header>

    <section id="admin-dashboard" class="dashboard-section" style="background-color: #fff;">
        <div class="container">
            <h2>Visão Geral do Sistema</h2>
            
            <?php if ($message): ?>
                <div style="padding: 15px; margin-bottom: 20px; background-color: #e8f5e9; color: #388e3c; border: 1px solid #388e3c; border-radius: 4px;"><?php echo $message; ?></div>
            <?php endif; ?>

            <div class="stats-grid">
                <div class="stat-card">
                    <h3>Total de Clientes</h3>
                    <p class="stat-value"><?php echo $total_users; ?></p>
                </div>
                <div class="stat-card">
                    <h3>Clientes Ativos</h3>
                    <p class="stat-value stat-success"><?php echo $active_users; ?></p>
                </div>
                <div class="stat-card">
                    <h3>Pagamentos Pendentes</h3>
                    <p class="stat-value stat-alert"><?php echo count($pending_payments); ?></p>
                </div>
                <div class="stat-card">
                    <h3>Comissões Pendentes</h3>
                    <p class="stat-value stat-commission">R$ <?php echo number_format($pending_commissions, 2, ',', '.'); ?></p>
                </div>
            </div>

            <h3 style="margin-top: 40px; color: #f44336;">💳 Ações Urgentes: Pagamentos PIX Pendentes</h3>
            
            <?php if (empty($pending_payments)): ?>
                <p style="text-align: center; font-style: italic; color: #555;">Nenhum pagamento PIX pendente no momento. Tudo OK!</p>
            <?php else: ?>
                <table class="data-table">
                    <thead>
                        <tr>
                            <th>ID Pag.</th>
                            <th>Nome Cliente</th>
                            <th>Data</th>
                            <th>Valor</th>
                            <th>Comprovante</th>
                            <th>Ação</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($pending_payments as $payment): ?>
                            <tr>
                                <td>#<?php echo $payment['payment_id']; ?></td>
                                <td><?php echo htmlspecialchars($payment['nome']); ?></td>
                                <td><?php echo date('d/m H:i', strtotime($payment['data_pagamento'])); ?></td>
                                <td class="td-value">R$ <?php echo number_format($payment['valor'], 2, ',', '.'); ?></td>
                                <td><a href="<?php echo htmlspecialchars($payment['comprovante_url'] ?: '#'); ?>" target="_blank">Ver</a></td>
                                <td>
                                    <a href="approve_payment.php?user_id=<?php echo $payment['user_id']; ?>&payment_id=<?php echo $payment['payment_id']; ?>" class="action-button approve" onclick="return confirm('Tem certeza que deseja ATIVAR este usuário e gerar as comissões?');">
                                        Aprovar e Ativar
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php endif; ?>

        </div>
    </section>
</body>
</html>