<?php
// admin/approve_payment.php
include 'security_check.php'; // Protege a página (só Admin acessa)
include_once '../config.php';
include_once '../functions/mlm_logic.php'; // Inclui a lógica de comissionamento

if (isset($_GET['user_id']) && isset($_GET['payment_id'])) {
    
    $user_id = (int)$_GET['user_id'];
    $payment_id = (int)$_GET['payment_id'];
    
    // 1. Buscar o valor do pagamento para usá-lo no cálculo da comissão
    $stmt_value = $conn->prepare("SELECT valor FROM payments WHERE id = ? AND user_id = ? AND status = 'pendente'");
    $stmt_value->bind_param("ii", $payment_id, $user_id);
    $stmt_value->execute();
    $result_value = $stmt_value->get_result();

    if ($result_value->num_rows === 0) {
        $_SESSION['admin_message'] = "Erro: Pagamento não encontrado, já processado, ou ID de usuário incorreto.";
        header("Location: dashboard.php");
        exit;
    }

    $payment_data = $result_value->fetch_assoc();
    $amount = $payment_data['valor']; // Valor que será base para o cálculo MLM
    
    // 2. Chama a função principal de ativação
    if (activate_user_and_trigger_mlm($user_id, $amount, $payment_id)) {
        // Salva uma mensagem de sucesso na sessão para exibir no Dashboard
        $_SESSION['admin_message'] = "✅ Sucesso! Usuário ID {$user_id} ATIVADO e comissões de 5 níveis geradas. Cliente já pode treinar!";
    } else {
        $_SESSION['admin_message'] = "❌ Erro! Falha ao ativar o usuário ou gerar comissões.";
    }

    // Redireciona de volta para a Dashboard
    header("Location: dashboard.php");
    exit;

} else {
    $_SESSION['admin_message'] = "Erro! Parâmetros de aprovação ausentes.";
    header("Location: dashboard.php");
    exit;
}
?>